-- Create all objects in the Master Repgroup at MasterDefinitionSite
begin
dbms_repcat.create_master_repobject(
 sname => 'repadmin',
 oname => 'emp',
 type => 'table',
 use_existing_object => FALSE,
 comment => 'create table emp in master group',
 retry => FALSE,
 copy_rows => TRUE,
 gname => 'acct');

dbms_repcat.create_master_repobject(
 sname => 'repadmin',
 oname => 'dept',
 type => 'table',
 use_existing_object => FALSE,
 comment => 'create table dept in master group',
 retry => FALSE,
 copy_rows => TRUE,
 gname => 'acct');

dbms_repcat.create_master_repobject(
 sname => 'repadmin',
 oname => 'bonus',
 type => 'table',
 use_existing_object => FALSE,
 comment => 'create table bonus in master group',
 retry => FALSE,
 copy_rows => TRUE,
 gname => 'acct');

dbms_repcat.create_master_repobject(
 sname => 'repadmin',
 oname => 'salgrade',
 type => 'table',
 use_existing_object => FALSE,
 comment => 'create table salgrade in master group',
 retry => FALSE,
 copy_rows => TRUE,
 gname => 'acct');

dbms_repcat.create_master_repobject(
 sname => 'repadmin',
 oname => 'emp_pk',
 type => 'index',
 use_existing_object => FALSE,
 ddl_text => 'alter table emp add constraint emp_pk primary key(empno)',
 comment => 'create index on table emp',
 retry => FALSE,
 copy_rows => TRUE,
 gname => 'acct');

dbms_repcat.create_master_repobject(
 sname => 'repadmin',
 oname => 'dept_pk',
 type => 'index',
 use_existing_object => FALSE,
 ddl_text => 'alter table dept add constraint dept_pk primary key(deptno)',
 comment => 'create index on table dept',
 retry => FALSE,
 copy_rows => TRUE,
 gname => 'acct');

dbms_repcat.create_master_repobject(
 sname => 'repadmin',
 oname => 'bonus_pk',
 type => 'index',
 use_existing_object => FALSE,
 ddl_text => 'alter table bonus add constraint bonus_pk primary key(ename)',
 comment => 'create index on table bonus',
 retry => FALSE,
 copy_rows => TRUE,
 gname => 'acct');

dbms_repcat.create_master_repobject(
 sname => 'repadmin',
 oname => 'salgrade_pk',
 type => 'index',
 use_existing_object => FALSE,
 ddl_text => 'alter table salgrade add constraint salgrade_pk primary key(grade)',
 comment => 'create index on table salgrade',
 retry => FALSE,
 copy_rows => TRUE,
 gname => 'acct');

dbms_repcat.create_master_repobject(
 sname => 'repadmin',
 oname => 'emp_syn',
 type => 'synonym',
 use_existing_object => FALSE,
 ddl_text => 'create synonym emp_syn for emp',
 comment => 'create emp synonym',
 retry => FALSE,
 copy_rows => TRUE,
 gname => 'acct');

dbms_repcat.create_master_repobject(
 sname => 'repadmin',
 oname => 'emp_view',
 type => 'view',
 use_existing_object => FALSE,
 ddl_text => 'create view emp_view as select empno,ename,comm from emp',
 comment => 'create emp_view on table emp',
 retry => FALSE,
 copy_rows => TRUE,
 gname => 'acct');

dbms_repcat.create_master_repobject(
 sname => 'repadmin',
 oname => 'val_name',
 type => 'function',
 use_existing_object => FALSE,
 ddl_text => 'create or replace function val_name (name in varchar2) return boolean is begin if name = ''NICO'' then return FALSE; else return FALSE; end if; end;',
 comment => 'create function val_name',
 retry => FALSE,
 copy_rows => TRUE,
 gname => 'acct');

dbms_repcat.create_master_repobject(
 sname => 'repadmin',
 oname => 'emp_proc',
 type => 'procedure',
 use_existing_object => FALSE,
 ddl_text => 'create or replace procedure emp_proc
              (var_empno in number,var_ename in varchar2) is 
              begin
                if var_empno = 1 then
                   dbms_output.put_line(''1'');
                else
                   dbms_output.put_line(''not 1'');
                end if;
              end;',
 comment => 'create procedure emp_proc to return ename accept empno as arg',
 retry => FALSE,
 copy_rows => TRUE,
 gname => 'acct');

end;
/
