create or replace 
package            "EMP$RR" as                                                  
  function unique_conflict_insert_handler(                                      
    "COMM1_n" IN NUMBER,                                                        
    "DEPTNO2_n" IN NUMBER,                                                      
    "EMPNO3_n" IN NUMBER,                                                       
    "ENAME4_n" IN VARCHAR2,                                                     
    "HIREDATE5_n" IN DATE,                                                      
    "JOB6_n" IN VARCHAR2,                                                       
    "MGR7_n" IN NUMBER,                                                         
    "SAL8_n" IN NUMBER,                                                         
    "UPDATE_TIME9_n" IN DATE,                                                   
    site_name IN VARCHAR2,                                                      
    propagation_flag IN CHAR,                                                   
    errmsg IN VARCHAR2) return boolean;                                         
  function delete_conflict_handler(                                             
    "COMM1_o" IN NUMBER,                                                        
    "DEPTNO2_o" IN NUMBER,                                                      
    "EMPNO3_o" IN NUMBER,                                                       
    "ENAME4_o" IN VARCHAR2,                                                     
    "HIREDATE5_o" IN DATE,                                                      
    "JOB6_o" IN VARCHAR2,                                                       
    "MGR7_o" IN NUMBER,                                                         
    "SAL8_o" IN NUMBER,                                                         
    "UPDATE_TIME9_o" IN DATE,                                                   
    site_name IN VARCHAR2,                                                      
    propagation_flag IN CHAR,                                                   
    column_changed$ IN RAW,                                                     
    column_sent$_varchar2 IN VARCHAR2) return boolean;                          
  function update_conflict_handler(                                             
    "COMM1_o" IN NUMBER,                                                        
    "COMM1_n" IN NUMBER,                                                        
    "DEPTNO2_o" IN NUMBER,                                                      
    "DEPTNO2_n" IN NUMBER,                                                      
    "EMPNO3_o" IN NUMBER,                                                       
    "EMPNO3_n" IN NUMBER,                                                       
    "ENAME4_o" IN VARCHAR2,                                                     
    "ENAME4_n" IN VARCHAR2,                                                     
    "HIREDATE5_o" IN DATE,                                                      
    "HIREDATE5_n" IN DATE,                                                      
    "JOB6_o" IN VARCHAR2,                                                       
    "JOB6_n" IN VARCHAR2,                                                       
    "MGR7_o" IN NUMBER,                                                         
    "MGR7_n" IN NUMBER,                                                         
    "SAL8_o" IN NUMBER,                                                         
    "SAL8_n" IN NUMBER,                                                         
    "UPDATE_TIME9_o" IN DATE,                                                   
    "UPDATE_TIME9_n" IN DATE,                                                   
    site_name IN VARCHAR2,                                                      
    propagation_flag IN CHAR,                                                   
    column_changed$ IN RAW,                                                     
    column_sent$_varchar2 IN VARCHAR2,                                          
    column_changed$_varchar2 IN VARCHAR2) return boolean;                       
  function unique_conflict_update_handler(                                      
    "COMM1_o" IN NUMBER,                                                        
    "COMM1_n" IN NUMBER,                                                        
    "DEPTNO2_o" IN NUMBER,                                                      
    "DEPTNO2_n" IN NUMBER,                                                      
    "EMPNO3_o" IN NUMBER,                                                       
    "EMPNO3_n" IN NUMBER,                                                       
    "ENAME4_o" IN VARCHAR2,                                                     
    "ENAME4_n" IN VARCHAR2,                                                     
    "HIREDATE5_o" IN DATE,                                                      
    "HIREDATE5_n" IN DATE,                                                      
    "JOB6_o" IN VARCHAR2,                                                       
    "JOB6_n" IN VARCHAR2,                                                       
    "MGR7_o" IN NUMBER,                                                         
    "MGR7_n" IN NUMBER,                                                         
    "SAL8_o" IN NUMBER,                                                         
    "SAL8_n" IN NUMBER,                                                         
    "UPDATE_TIME9_o" IN DATE,                                                   
    "UPDATE_TIME9_n" IN DATE,                                                   
    site_name IN VARCHAR2,                                                      
    propagation_flag IN CHAR,                                                   
    column_changed$ IN RAW,                                                     
    column_sent$_varchar2 IN VARCHAR2,                                          
    column_changed$_varchar2 IN VARCHAR2,                                       
    errmsg IN VARCHAR2) return boolean;                                         
end "EMP$RR";                                                                   
/
create or replace 
package body            "EMP$RR" as                                             
  function update_decl1 /* LATEST TIMESTAMP */ (                                
    ignore_discard_flag out boolean) return boolean                             
  is                                                                            
  begin                                                                         
    if DBMS_REPUTIL.MAXIMUM(                                                    
      "UPDATE_TIME9_n",                                                         
      "UPDATE_TIME9_c",                                                         
      ignore_discard_flag) then                                                 
      if ignore_discard_flag then                                               
      return TRUE;                                                              
    else                                                                        
      return FALSE;                                                             
    end if;                                                                     
  end if;                                                                     
  end update_decl1;                                                             
  function unique_conflict_insert_handler(                                      
    "COMM1_n" IN NUMBER,                                                        
    "DEPTNO2_n" IN NUMBER,                                                      
    "EMPNO3_n" IN NUMBER,                                                       
    "ENAME4_n" IN VARCHAR2,                                                     
    "HIREDATE5_n" IN DATE,                                                      
    "JOB6_n" IN VARCHAR2,                                                       
    "MGR7_n" IN NUMBER,                                                         
    "SAL8_n" IN NUMBER,                                                         
    "UPDATE_TIME9_n" IN DATE,                                                   
    site_name IN VARCHAR2,                                                      
    propagation_flag IN CHAR,                                                   
    errmsg IN VARCHAR2) return boolean is                                       
  begin                                                                         
    return FALSE;                                                               
  end unique_conflict_insert_handler;                                           
  function delete_conflict_handler(                                             
    "COMM1_o" IN NUMBER,                                                        
    "DEPTNO2_o" IN NUMBER,                                                      
    "EMPNO3_o" IN NUMBER,                                                       
    "ENAME4_o" IN VARCHAR2,                                                     
    "HIREDATE5_o" IN DATE,                                                      
    "JOB6_o" IN VARCHAR2,                                                       
    "MGR7_o" IN NUMBER,                                                         
    "SAL8_o" IN NUMBER,                                                         
    "UPDATE_TIME9_o" IN DATE,                                                   
    site_name IN VARCHAR2,                                                      
    propagation_flag IN CHAR,                                                   
    column_changed$ IN RAW,                                                     
    column_sent$_varchar2 IN VARCHAR2) return boolean is                        
  begin                                                                         
    return FALSE;                                                               
  end delete_conflict_handler;                                                  
  function update_conflict_handler(                                             
    "COMM1_o" IN NUMBER,                                                        
    "COMM1_n" IN NUMBER,                                                        
    "DEPTNO2_o" IN NUMBER,                                                      
    "DEPTNO2_n" IN NUMBER,                                                      
    "EMPNO3_o" IN NUMBER,                                                       
    "EMPNO3_n" IN NUMBER,                                                       
    "ENAME4_o" IN VARCHAR2,                                                     
    "ENAME4_n" IN VARCHAR2,                                                     
    "HIREDATE5_o" IN DATE,                                                      
    "HIREDATE5_n" IN DATE,                                                      
    "JOB6_o" IN VARCHAR2,                                                       
    "JOB6_n" IN VARCHAR2,                                                       
    "MGR7_o" IN NUMBER,                                                         
    "MGR7_n" IN NUMBER,                                                         
    "SAL8_o" IN NUMBER,                                                         
    "SAL8_n" IN NUMBER,                                                         
    "UPDATE_TIME9_o" IN DATE,                                                   
    "UPDATE_TIME9_n" IN DATE,                                                   
    site_name IN VARCHAR2,                                                      
    propagation_flag IN CHAR,                                                   
    column_changed$ IN RAW,                                                     
    column_sent$_varchar2 IN VARCHAR2,                                          
    column_changed$_varchar2 IN VARCHAR2) return boolean is                     
    "COMM1_c" NUMBER;                                                           
    "DEPTNO2_c" NUMBER;                                                         
    "EMPNO3_c" NUMBER;                                                          
    "ENAME4_c" VARCHAR2(10);                                                    
    "HIREDATE5_c" DATE;                                                         
    "JOB6_c" VARCHAR2(9);                                                       
    "MGR7_c" NUMBER;                                                            
    "SAL8_c" NUMBER;                                                            
    "UPDATE_TIME9_c" DATE;                                                      
    old_equal_new boolean := true;                                              
    no_change boolean := true;                                                  
    ignore_discard_flag boolean := false;                                       
  begin                                                                         
    select                                                                      
      "COMM",                                                                   
      "DEPTNO",                                                                 
      "EMPNO",                                                                  
      "ENAME",                                                                  
      "HIREDATE",                                                               
      "JOB",                                                                    
      "MGR",                                                                    
      "SAL",                                                                    
      "UPDATE_TIME"                                                             
      into                                                                      
      "COMM1_c",                                                                
      "DEPTNO2_c",                                                              
      "EMPNO3_c",                                                               
      "ENAME4_c",                                                               
      "HIREDATE5_c",                                                            
      "JOB6_c",                                                                 
      "MGR7_c",                                                                 
      "SAL8_c",                                                                 
      "UPDATE_TIME9_c"                                                          
      from "EMP"                                                                
      where (("EMPNO" = "EMPNO3_o") or                                          
            ("EMPNO" is null and "EMPNO3_o" is null));                          
    old_equal_new :=;                                                           
    if old_equal_new                                                            
      or (                                                                      
       ) then                                                                   
      no_change := no_change and old_equal_new;                                 
    else                                                                        
      ignore_discard_flag := false;                                             
      if update_decl1( /* LATEST TIMESTAMP */                                   
        ignore_discard_flag) then                                               
        dbms_reputil.enter_statistics(                                          
          'REPADMIN',                                                           
          'EMP',                                                                
          'UPDATE',                                                             
          'EMP_SUMM',                                                           
          'LATEST TIMESTAMP',                                                   
          'DBMS_REPUTIL.MAXIMUM',                                               
          NULL,                                                                 
          "EMPNO3_n");                                                          
      else                                                                      
        return FALSE;                                                           
      end if;                                                                   
      no_change := no_change and ignore_discard_flag;                           
    end if;                                                                     
    old_equal_new := (                                                          
            dbms_reputil2.old_number_eq_new(column_changed$_varchar2, 1,        
                "COMM1_o", "COMM1_n") and                                       
            dbms_reputil2.old_number_eq_new(column_changed$_varchar2, 2,        
                "DEPTNO2_o", "DEPTNO2_n") and                                   
            dbms_reputil2.old_number_eq_new(column_changed$_varchar2, 3,        
                "EMPNO3_o", "EMPNO3_n") and                                     
            dbms_reputil2.old_varchar2_eq_new(column_changed$_varchar2, 4,      
                "ENAME4_o", "ENAME4_n") and                                     
            dbms_reputil2.old_date_eq_new(column_changed$_varchar2, 5,          
                "HIREDATE5_o", "HIREDATE5_n") and                               
            dbms_reputil2.old_varchar2_eq_new(column_changed$_varchar2, 6,      
                "JOB6_o", "JOB6_n") and                                         
            dbms_reputil2.old_number_eq_new(column_changed$_varchar2, 7,        
                "MGR7_o", "MGR7_n") and                                         
            dbms_reputil2.old_number_eq_new(column_changed$_varchar2, 8,        
                "SAL8_o", "SAL8_n") and                                         
            dbms_reputil2.old_date_eq_new(column_changed$_varchar2, 9,          
                "UPDATE_TIME9_o", "UPDATE_TIME9_n"));                           
    if old_equal_new                                                            
      or                                                                        
       ( (                                                                      
       dbms_reputil2.old_number_eq_current(column_sent$_varchar2, 1,            
         "COMM1_o", "COMM1_c") and                                              
       dbms_reputil2.old_number_eq_current(column_sent$_varchar2, 2,            
         "DEPTNO2_o", "DEPTNO2_c") and                                          
       dbms_reputil2.old_number_eq_current(column_sent$_varchar2, 3,            
         "EMPNO3_o", "EMPNO3_c") and                                            
       dbms_reputil2.old_varchar2_eq_current(column_sent$_varchar2, 4,          
         "ENAME4_o", "ENAME4_c") and                                            
       dbms_reputil2.old_date_eq_current(column_sent$_varchar2, 5,              
         "HIREDATE5_o", "HIREDATE5_c") and                                      
       dbms_reputil2.old_varchar2_eq_current(column_sent$_varchar2, 6,          
         "JOB6_o", "JOB6_c") and                                                
       dbms_reputil2.old_number_eq_current(column_sent$_varchar2, 7,            
         "MGR7_o", "MGR7_c") and                                                
       dbms_reputil2.old_number_eq_current(column_sent$_varchar2, 8,            
         "SAL8_o", "SAL8_c") and                                                
       dbms_reputil2.old_date_eq_current(column_sent$_varchar2, 9,              
         "UPDATE_TIME9_o", "UPDATE_TIME9_c"))                                   
       ) then                                                                   
      no_change := no_change and old_equal_new;                                 
    else                                                                        
      return FALSE;                                                             
    end if;                                                                     
    if not no_change then                                                       
      "EMP$RP".rep_update(                                                      
        null,                                                                   
        "COMM1_o",                                                              
        "COMM1_n",                                                              
        "DEPTNO2_o",                                                            
        "DEPTNO2_n",                                                            
        "EMPNO3_o",                                                             
        "EMPNO3_n",                                                             
        "ENAME4_o",                                                             
        "ENAME4_n",                                                             
        "HIREDATE5_o",                                                          
        "HIREDATE5_n",                                                          
        "JOB6_o",                                                               
        "JOB6_n",                                                               
        "MGR7_o",                                                               
        "MGR7_n",                                                               
        "SAL8_o",                                                               
        "SAL8_n",                                                               
        "UPDATE_TIME9_o",                                                       
        "UPDATE_TIME9_n",                                                       
        site_name,                                                              
        propagation_flag);                                                      
    end if;                                                                     
    return TRUE;                                                                
  end update_conflict_handler;                                                  
  function unique_conflict_update_handler(                                      
    "COMM1_o" IN NUMBER,                                                        
    "COMM1_n" IN NUMBER,                                                        
    "DEPTNO2_o" IN NUMBER,                                                      
    "DEPTNO2_n" IN NUMBER,                                                      
    "EMPNO3_o" IN NUMBER,                                                       
    "EMPNO3_n" IN NUMBER,                                                       
    "ENAME4_o" IN VARCHAR2,                                                     
    "ENAME4_n" IN VARCHAR2,                                                     
    "HIREDATE5_o" IN DATE,                                                      
    "HIREDATE5_n" IN DATE,                                                      
    "JOB6_o" IN VARCHAR2,                                                       
    "JOB6_n" IN VARCHAR2,                                                       
    "MGR7_o" IN NUMBER,                                                         
    "MGR7_n" IN NUMBER,                                                         
    "SAL8_o" IN NUMBER,                                                         
    "SAL8_n" IN NUMBER,                                                         
    "UPDATE_TIME9_o" IN DATE,                                                   
    "UPDATE_TIME9_n" IN DATE,                                                   
    site_name IN VARCHAR2,                                                      
    propagation_flag IN CHAR,                                                   
    column_changed$ IN RAW,                                                     
    column_sent$_varchar2 IN VARCHAR2,                                          
    column_changed$_varchar2 IN VARCHAR2,                                       
    errmsg IN VARCHAR2) return boolean is                                       
  begin                                                                         
    return FALSE;                                                               
  end unique_conflict_update_handler;                                           
end "EMP$RR";                                                                   
/
select * from user_errors;
