﻿using System;
using System.Data;
using System.Collections.Generic;
using System.Text;
using Oracle.DataAccess.Client;
using Geo;

//minimal requirements 
//Oracle 11.1 client
//odp.net release 11.1.0.6.20

/* Oracle DDL
create table geoinfo (id number(10) not null, geo mdsys.sdo_geometry );
alter table geoinfo add primary key (id); 
create sequence geoinfo_seq; 
*/ 

namespace ConsoleApplicationUdt
{
  //geoinfo%rowtype -> GeoInfo
  public class GeoInfo
  {
    private decimal id;
    public decimal Id
    {
      get { return id; }
      set { id = value; }
    }

    private SdoGeometry geo;
    public SdoGeometry Geo
    {
      get { return geo; }
      set { geo = value; }
    }
  }
  
  class Program
  {
    static void Main(string[] args)
    {
      using (OracleConnection con = new OracleConnection("user id=scott;password=tiger;data source=ORA11"))
      {
        con.Open();

        using (OracleCommand cmd = new OracleCommand())
        {
          cmd.Connection = con; 
          cmd.CommandType = CommandType.Text;

          //create parameter for insert SdoGeometry in table geoinfo
          cmd.CommandText = " insert into geoinfo values (geoinfo_seq.nextval,:param) ";
          cmd.Parameters.Clear();
          OracleParameter oracleParameterGeo = new OracleParameter();
          oracleParameterGeo.OracleDbType = OracleDbType.Object;
          oracleParameterGeo.UdtTypeName = "MDSYS.SDO_GEOMETRY";
          cmd.Parameters.Add(oracleParameterGeo);

          //creating point
          SdoGeometry geoPoint = new SdoGeometry();
          geoPoint.Sdo_Gtype = 2001; 
          geoPoint.Point = new SdoPoint();
          geoPoint.Point.X = 200;
          geoPoint.Point.Y = 400;
          oracleParameterGeo.Value = geoPoint;

          //insert point in table geoinfo
          cmd.ExecuteNonQuery();

          //creating polygon
          SdoGeometry geoPolygon = new SdoGeometry();
          geoPolygon.Sdo_Gtype = 2003;
          geoPolygon.ElemArray = new decimal[] { 1, 1003, 1 };
          geoPolygon.OrdinatesArray = new decimal[] { 3, 3, 3, 10, 10, 10, 10, 3, 3, 3 };
          oracleParameterGeo.Value = geoPolygon; 

          //insert polygon into table geoinfo 
          cmd.ExecuteNonQuery();
          
          //select number(10),sdo_geometry into List<GeoInfo>
          List<GeoInfo> geoInfoList = new List<GeoInfo>();
 
          cmd.Parameters.Clear();
          cmd.CommandText = " select id,geo from geoinfo ";

          using (OracleDataReader readerGeoInfo = cmd.ExecuteReader())
          {
            while (readerGeoInfo.Read())
            {
              GeoInfo geoInfo = new GeoInfo();
              if (!readerGeoInfo.IsDBNull(0))
              {
                geoInfo.Id = readerGeoInfo.GetDecimal(0);
              }
              if (!readerGeoInfo.IsDBNull(1))
              {
                geoInfo.Geo = (SdoGeometry)readerGeoInfo.GetValue(1); 
              }
              geoInfoList.Add(geoInfo);
            }
            readerGeoInfo.Close();
          }
        }
        con.Close();
      }
    }
  }
}
